/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.caitlin.stencilhelp.client;

import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StateCapsule;
import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StencilApplication;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Frame;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Hole;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Menu;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.NavigationBar;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.Note;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.ObjectPositionManager;
import edu.cmu.cs.stage3.caitlin.stencilhelp.client.StencilManager;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.xml.NodeUtilities;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StencilParser {
    StringBuffer textBuffer;
    StencilManager stencilManager;
    ObjectPositionManager positionManager;
    StencilApplication stencilApp;

    public StencilParser(StencilManager stencilManager, ObjectPositionManager positionManager, StencilApplication stencilApp) {
        this.stencilManager = stencilManager;
        this.positionManager = positionManager;
        this.stencilApp = stencilApp;
    }

    protected void loadStateCapsule(Node node, StencilManager.Stencil newStencil) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String capsuleString;
            Node child = nl.item(i);
            if (child.getNodeValue() != null && (capsuleString = child.getNodeValue().trim()).length() > 0) {
                StateCapsule stateCapsule = this.stencilApp.getStateCapsuleFromString(capsuleString);
                newStencil.setEndState(stateCapsule);
            }
            ++i;
        }
    }

    protected void loadNote(Node node, StencilManager.Stencil newStencil, NavigationBar navBar) {
        Note note;
        Point initPos;
        Point p;
        NodeList noteParts = node.getChildNodes();
        NamedNodeMap attr = node.getAttributes();
        Node objectType = attr.getNamedItem("type");
        Node xPosNode = attr.getNamedItem("xPos");
        Node yPosNode = attr.getNamedItem("yPos");
        Node autoAdvanceNode = attr.getNamedItem("autoAdvance");
        Node advanceEventNode = attr.getNamedItem("advanceEvent");
        Node hasNextNode = attr.getNamedItem("hasNext");
        boolean hasNext = false;
        int advanceEvent = 0;
        if (hasNextNode != null && hasNextNode.getNodeValue().equals("true")) {
            hasNext = true;
        }
        String message = "hello world";
        Vector<String> msgs = new Vector<String>();
        Vector<String> colors = new Vector<String>();
        String id = "id";
        int i = 0;
        while (i < noteParts.getLength()) {
            Node noteDetails = noteParts.item(i);
            if (noteDetails.getNodeName().equals("id")) {
                id = NodeUtilities.getNodeText(noteDetails);
            } else if (noteDetails.getNodeName().equals("message")) {
                NamedNodeMap textAttr;
                message = NodeUtilities.getNodeText(noteDetails);
                if (message.length() > 0) {
                    msgs.addElement(message);
                }
                if ((textAttr = noteDetails.getAttributes()) != null) {
                    Node textColor = textAttr.getNamedItem("color");
                    if (textColor != null) {
                        colors.addElement(textColor.getNodeValue());
                    } else {
                        colors.addElement(null);
                    }
                } else {
                    colors.addElement(null);
                }
            }
            ++i;
        }
        if (objectType.getNodeValue().equals("hole")) {
            Hole hole = new Hole(id, this.positionManager, this.stencilApp, this.stencilManager);
            p = hole.getNotePoint();
            initPos = new Point((int)Double.parseDouble(xPosNode.getNodeValue()), (int)Double.parseDouble(yPosNode.getNodeValue()));
            note = new Note(p, initPos, hole, this.positionManager, this.stencilManager, hasNext);
            int i2 = 0;
            while (i2 < msgs.size()) {
                note.addText((String)msgs.elementAt(i2), (String)colors.elementAt(i2));
                ++i2;
            }
            boolean autoAdvance = false;
            if (autoAdvanceNode != null && autoAdvanceNode.getNodeValue().equals("true")) {
                autoAdvance = true;
            }
            if (advanceEventNode != null) {
                advanceEvent = advanceEventNode.getNodeValue().equals("mousePress") ? 1 : (advanceEventNode.getNodeValue().equals("mouseClick") ? 0 : 2);
            }
            hole.setAutoAdvance(autoAdvance, advanceEvent);
            newStencil.addObject(hole);
            newStencil.addObject(note);
        } else if (objectType.getNodeValue().equals("frame")) {
            Frame frame = new Frame(id, this.positionManager);
            p = frame.getNotePoint();
            initPos = new Point((int)Double.parseDouble(xPosNode.getNodeValue()), (int)Double.parseDouble(yPosNode.getNodeValue()));
            note = new Note(p, initPos, frame, this.positionManager, this.stencilManager, hasNext);
            int i3 = 0;
            while (i3 < msgs.size()) {
                note.addText((String)msgs.elementAt(i3), (String)colors.elementAt(i3));
                ++i3;
            }
            newStencil.addObject(frame);
            newStencil.addObject(note);
        } else if (objectType.getNodeValue().equals("navBar")) {
            Point p2 = navBar.getNotePoint();
            Point initPos2 = new Point((int)Double.parseDouble(xPosNode.getNodeValue()), (int)Double.parseDouble(yPosNode.getNodeValue()));
            Note note2 = new Note(p2, initPos2, navBar, this.positionManager, this.stencilManager, hasNext);
            int i4 = 0;
            while (i4 < msgs.size()) {
                note2.addText((String)msgs.elementAt(i4), (String)colors.elementAt(i4));
                ++i4;
            }
            newStencil.addObject(note2);
        } else {
            double xRatio = Double.parseDouble(xPosNode.getNodeValue());
            double yRatio = Double.parseDouble(yPosNode.getNodeValue());
            Point p3 = new Point((int)(this.stencilApp.getScreenSize().getWidth() * xRatio), (int)(this.stencilApp.getScreenSize().getHeight() * yRatio));
            Note note3 = new Note(p3, new Point(0, 0), null, this.positionManager, this.stencilManager, hasNext);
            int i5 = 0;
            while (i5 < msgs.size()) {
                note3.addText((String)msgs.elementAt(i5), (String)colors.elementAt(i5));
                ++i5;
            }
            newStencil.addObject(note3);
        }
    }

    protected StencilManager.Stencil loadStencil(Node node) {
        NamedNodeMap attr = node.getAttributes();
        Node stencilTitle = attr.getNamedItem("title");
        NavigationBar navBar = new NavigationBar(this.stencilManager, this.positionManager);
        if (stencilTitle != null && stencilTitle.getNodeValue() != null) {
            navBar.setTitleString(stencilTitle.getNodeValue());
        }
        NodeList objects = node.getChildNodes();
        Node stepsToGoBackNode = attr.getNamedItem("stepsToGoBack");
        int stepsToGoBack = 1;
        if (stepsToGoBackNode != null && stepsToGoBackNode.getNodeValue() != null) {
            stepsToGoBack = Integer.parseInt(stepsToGoBackNode.getNodeValue());
        }
        StencilManager.Stencil newStencil = this.stencilManager.newStencil(stepsToGoBack);
        newStencil.addObject(navBar);
        newStencil.addObject(new Menu(this.stencilManager));
        int i = 0;
        while (i < objects.getLength()) {
            Node childNode = objects.item(i);
            if (childNode.getNodeName().equals("note")) {
                this.loadNote(childNode, newStencil, navBar);
            } else if (childNode.getNodeName().equals("stateCapsule")) {
                this.loadStateCapsule(childNode, newStencil);
            }
            ++i;
        }
        return newStencil;
    }

    public Vector parseFile(File fileToLoad) {
        Document document;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(fileToLoad);
        }
        catch (IOException ioe) {
            document = null;
            ioe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            document = null;
            pce.printStackTrace();
        }
        catch (SAXException se) {
            document = null;
            se.printStackTrace();
        }
        if (document != null) {
            Node previousStackNode;
            Vector<StencilManager.Stencil> stencilList = new Vector<StencilManager.Stencil>();
            NamedNodeMap attr = document.getDocumentElement().getAttributes();
            Node readPermission = attr.getNamedItem("access");
            if (readPermission.getNodeValue().equals("read")) {
                this.stencilManager.setWriteEnabled(false);
            } else {
                this.stencilManager.setWriteEnabled(true);
            }
            Node worldToLoad = attr.getNamedItem("world");
            if (worldToLoad != null) {
                this.stencilManager.setWorld(worldToLoad.getNodeValue());
            }
            String nextStack = null;
            String previousStack = null;
            Node nextStackNode = attr.getNamedItem("nextStack");
            if (nextStackNode != null) {
                nextStack = nextStackNode.getNodeValue();
            }
            if ((previousStackNode = attr.getNamedItem("previousStack")) != null) {
                previousStack = previousStackNode.getNodeValue();
            }
            if (nextStack != null || previousStack != null) {
                this.stencilManager.setNextAndPreviousStacks(previousStack, nextStack);
            }
            NodeList stencils = document.getElementsByTagName("stencil");
            ProgressMonitor monitor = new ProgressMonitor(null, Messages.getString("Loading_Tutorial"), "", 0, stencils.getLength());
            monitor.setProgress(0);
            monitor.setMillisToDecideToPopup(1000);
            int i = 0;
            while (i < stencils.getLength()) {
                Node stencilNode = stencils.item(i);
                StencilManager.Stencil newStencil = this.loadStencil(stencilNode);
                stencilList.addElement(newStencil);
                monitor.setProgress(i);
                ++i;
            }
            monitor.close();
            return stencilList;
        }
        System.out.println(Messages.getString("Could_not_parse_stencil_file"));
        System.out.flush();
        return null;
    }

    public StencilManager.Stencil getErrorStencil() {
        NavigationBar navBar = new NavigationBar(this.stencilManager, this.positionManager, true);
        navBar.setTitleString("Ooops!");
        StencilManager.Stencil newStencil = this.stencilManager.newStencil();
        newStencil.addObject(navBar);
        Point p = new Point((int)((double)((float)this.stencilApp.getScreenSize().getWidth()) * 0.292), (int)((double)((float)this.stencilApp.getScreenSize().getHeight()) * 0.448));
        Note note = new Note(p, new Point(0, 0), null, this.positionManager, this.stencilManager, false);
        note.addText(Messages.getString("The_Alice_tutorial_thinks_maybe_you_didn_t_follow_the_instructions_carefully_"), null);
        note.addText(Messages.getString("Please_back_up_to_your_mistake_or_restart_"), null);
        note.initializeNote();
        newStencil.addObject(note);
        return newStencil;
    }
}

