/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import java.awt.image.DataBuffer;

public class DataBufferFloat
extends DataBuffer {
    protected float[][] bankdata;
    protected float[] data;

    public DataBufferFloat(int size) {
        super(4, size);
        this.data = new float[size];
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(int size, int numBanks) {
        super(4, size, numBanks);
        this.bankdata = new float[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.bankdata[i] = new float[size];
            ++i;
        }
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[] dataArray, int size) {
        super(4, size);
        this.data = dataArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[] dataArray, int size, int offset) {
        super(4, size, 1, offset);
        this.data = dataArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[][] dataArray, int size) {
        super(4, size, dataArray.length);
        this.bankdata = dataArray;
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[][] dataArray, int size, int[] offsets) {
        super(4, size, dataArray.length, offsets);
        this.bankdata = dataArray;
        this.data = this.bankdata[0];
    }

    public float[] getData() {
        return this.data;
    }

    public float[] getData(int bank) {
        return this.bankdata[bank];
    }

    public float[][] getBankData() {
        return this.bankdata;
    }

    @Override
    public int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    @Override
    public int getElem(int bank, int i) {
        return (int)this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
    }

    @Override
    public float getElemFloat(int i) {
        return this.data[i + this.offset];
    }

    @Override
    public float getElemFloat(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
    }

    @Override
    public void setElemFloat(int bank, int i, float val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
    }

    @Override
    public double getElemDouble(int i) {
        return this.data[i + this.offset];
    }

    @Override
    public double getElemDouble(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElemDouble(int i, double val) {
        this.data[i + this.offset] = (float)val;
    }

    @Override
    public void setElemDouble(int bank, int i, double val) {
        this.bankdata[bank][i + this.offsets[bank]] = (float)val;
    }
}

