/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.GIFImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageCodec;
import edu.cmu.cs.stage3.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.image.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class GIFCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "gif";
    }

    @Override
    public Class getEncodeParamClass() {
        return Object.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return false;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        return null;
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        return new GIFImageDecoder(src, param);
    }

    @Override
    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return new GIFImageDecoder(new FileInputStream(src), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new GIFImageDecoder((InputStream)src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 4;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56;
    }
}

