/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.ImageCodec;
import edu.cmu.cs.stage3.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.image.codec.JPEGEncodeParam;
import edu.cmu.cs.stage3.image.codec.JPEGImageDecoder;
import edu.cmu.cs.stage3.image.codec.JPEGImageEncoder;
import edu.cmu.cs.stage3.image.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "jpeg";
    }

    @Override
    public Class getEncodeParamClass() {
        return JPEGEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        JPEGEncodeParam p = null;
        if (param != null) {
            p = (JPEGEncodeParam)param;
        }
        return new JPEGImageEncoder(dst, p);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        return new JPEGImageDecoder(src, null);
    }

    @Override
    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(src), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new JPEGImageDecoder((InputStream)src, null);
    }

    @Override
    public int getNumHeaderBytes() {
        return 3;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == -1 && header[1] == -40 && header[2] == -1;
    }
}

