/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.image.codec;

import edu.cmu.cs.stage3.image.codec.ImageCodec;
import edu.cmu.cs.stage3.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.image.codec.SeekableStream;
import edu.cmu.cs.stage3.image.codec.TIFFDecodeParam;
import edu.cmu.cs.stage3.image.codec.TIFFEncodeParam;
import edu.cmu.cs.stage3.image.codec.TIFFImageDecoder;
import edu.cmu.cs.stage3.image.codec.TIFFImageEncoder;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class TIFFCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "tiff";
    }

    @Override
    public Class getEncodeParamClass() {
        return TIFFEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return TIFFDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        return new TIFFImageEncoder(dst, param);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new TIFFImageDecoder(src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 4;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        if (header[0] == 73 && header[1] == 73 && header[2] == 42 && header[3] == 0) {
            return true;
        }
        return header[0] == 77 && header[1] == 77 && header[2] == 0 && header[3] == 42;
    }
}

