/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemTreeLoader
implements DirectoryTreeLoader {
    protected File root = null;
    protected File currentDirectory = null;
    protected InputStream currentlyOpenStream = null;

    @Override
    public void open(Object pathname) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (this.root != null) {
            this.close();
        }
        if (pathname instanceof String) {
            this.root = new File((String)pathname);
        } else if (pathname instanceof File) {
            this.root = (File)pathname;
        } else {
            throw new IllegalArgumentException(Messages.getString("pathname_must_be_an_instance_of_String_or_java_io_File"));
        }
        if (this.root.exists()) {
            if (!this.root.canRead()) {
                throw new IOException(String.valueOf(Messages.getString("cannot_read_")) + this.root);
            }
        } else {
            throw new FileNotFoundException(this.root + " " + Messages.getString("does_not_exist"));
        }
        this.currentDirectory = this.root;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentFile();
        this.root = null;
        this.currentDirectory = null;
    }

    @Override
    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        File newCurrentDirectory = pathname.length() == 0 || pathname.charAt(0) == '/' || pathname.charAt(0) == '\\' ? new File(String.valueOf(this.root.getAbsolutePath()) + pathname) : new File(String.valueOf(this.currentDirectory.getAbsolutePath()) + "/" + pathname);
        if (!newCurrentDirectory.exists()) {
            throw new IllegalArgumentException(newCurrentDirectory + " " + Messages.getString("doesn_t_exist"));
        }
        if (!newCurrentDirectory.isDirectory()) {
            throw new IllegalArgumentException(newCurrentDirectory + " " + Messages.getString("isn_t_a_directory"));
        }
        this.currentDirectory = newCurrentDirectory;
    }

    @Override
    public String getCurrentDirectory() {
        return this.getRelativePathname(this.currentDirectory);
    }

    @Override
    public InputStream readFile(String filename) throws FileNotFoundException, IOException {
        this.closeCurrentFile();
        File file = new File(this.currentDirectory, filename);
        if (!file.exists()) {
            throw new FileNotFoundException(file + " " + Messages.getString("does_not_exist"));
        }
        if (!file.canRead()) {
            throw new IOException(String.valueOf(Messages.getString("cannot_read_")) + file);
        }
        this.currentlyOpenStream = new FileInputStream(file);
        return this.currentlyOpenStream;
    }

    @Override
    public void closeCurrentFile() throws IOException {
        if (this.currentlyOpenStream != null) {
            this.currentlyOpenStream.close();
            this.currentlyOpenStream = null;
        }
    }

    @Override
    public String[] getFilesInCurrentDirectory() {
        File[] files = this.currentDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        });
        String[] filenames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filenames[i] = this.getRelativePathname(files[i]);
            ++i;
        }
        return filenames;
    }

    @Override
    public String[] getDirectoriesInCurrentDirectory() {
        File[] files = this.currentDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        String[] filenames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filenames[i] = this.getRelativePathname(files[i]);
            ++i;
        }
        return filenames;
    }

    protected String getRelativePathname(File file) {
        StringBuffer dir = new StringBuffer(file.getAbsolutePath());
        dir.delete(0, this.root.getAbsolutePath().length());
        return dir.toString();
    }

    @Override
    public boolean isKeepFileSupported() {
        return true;
    }

    static Object getKeepKey(File currentDirectory, String filename) {
        return new File(currentDirectory, filename).getAbsolutePath();
    }

    @Override
    public Object getKeepKey(String filename) throws KeepFileNotSupportedException {
        return FileSystemTreeLoader.getKeepKey(this.currentDirectory, filename);
    }
}

