/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.FileSystemTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileSystemTreeStorer
implements DirectoryTreeStorer {
    protected File root = null;
    protected File currentDirectory = null;
    protected OutputStream currentlyOpenStream = null;

    @Override
    public void open(Object pathname) throws IllegalArgumentException, IOException {
        if (this.root != null) {
            this.close();
        }
        if (pathname instanceof String) {
            this.root = new File((String)pathname);
        } else if (pathname instanceof File) {
            this.root = (File)pathname;
        } else {
            throw new IllegalArgumentException(Messages.getString("pathname_must_be_an_instance_of_String_or_java_io_File"));
        }
        if (this.root.exists()) {
            if (!this.root.canWrite()) {
                throw new IOException(String.valueOf(Messages.getString("cannot_write_to_")) + this.root);
            }
        } else {
            if (!this.root.mkdir()) {
                throw new IOException(String.valueOf(Messages.getString("cannot_create_")) + this.root);
            }
            if (!this.root.canWrite()) {
                throw new IOException(String.valueOf(Messages.getString("cannot_write_to_")) + this.root);
            }
        }
        this.currentDirectory = this.root;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentFile();
        this.root = null;
        this.currentDirectory = null;
    }

    @Override
    public void createDirectory(String pathname) throws IllegalArgumentException, IOException {
        if (pathname.indexOf(47) != -1) {
            throw new IllegalArgumentException(Messages.getString("pathname_cannot_contain_path_separators"));
        }
        if (pathname.length() <= 0) {
            throw new IllegalArgumentException(Messages.getString("pathname_has_no_length"));
        }
        File newDir = new File(this.currentDirectory, pathname);
        if (!newDir.exists() && !newDir.mkdir()) {
            throw new IOException(String.valueOf(Messages.getString("cannot_create_")) + newDir);
        }
    }

    @Override
    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        File newCurrentDirectory = pathname.length() == 0 || pathname.charAt(0) == '/' || pathname.charAt(0) == '\\' ? new File(String.valueOf(this.root.getAbsolutePath()) + pathname) : new File(String.valueOf(this.currentDirectory.getAbsolutePath()) + "/" + pathname);
        if (!newCurrentDirectory.exists()) {
            throw new IllegalArgumentException(newCurrentDirectory + " " + Messages.getString("doesn_t_exist"));
        }
        if (!newCurrentDirectory.isDirectory()) {
            throw new IllegalArgumentException(newCurrentDirectory + " " + Messages.getString("isn_t_a_directory"));
        }
        this.currentDirectory = newCurrentDirectory;
    }

    @Override
    public String getCurrentDirectory() {
        StringBuffer dir = new StringBuffer(this.currentDirectory.getAbsolutePath());
        dir.delete(0, this.root.getAbsolutePath().length());
        return dir.toString();
    }

    @Override
    public OutputStream createFile(String filename, boolean compressItIfYouGotIt) throws IllegalArgumentException, IOException {
        File newFile = new File(this.currentDirectory, filename);
        if (!newFile.exists() && !newFile.createNewFile()) {
            throw new IOException(String.valueOf(Messages.getString("cannot_create_")) + newFile);
        }
        if (!newFile.canWrite()) {
            throw new IOException(String.valueOf(Messages.getString("cannot_write_to_")) + newFile);
        }
        this.currentlyOpenStream = new FileOutputStream(newFile);
        return this.currentlyOpenStream;
    }

    @Override
    public void closeCurrentFile() throws IOException {
        if (this.currentlyOpenStream != null) {
            this.currentlyOpenStream.flush();
            this.currentlyOpenStream.close();
            this.currentlyOpenStream = null;
        }
    }

    @Override
    public Object getKeepKey(String filename) throws KeepFileNotSupportedException {
        return FileSystemTreeLoader.getKeepKey(this.currentDirectory, filename);
    }

    @Override
    public boolean isKeepFileSupported() {
        return true;
    }

    @Override
    public void keepFile(String filename) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        File file = new File(this.currentDirectory, filename);
        if (!file.exists()) {
            throw new KeepFileDoesNotExistException(this.currentDirectory.getAbsolutePath(), filename);
        }
    }
}

