/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mozilla.universalchardet.UniversalDetector;

public class ZipFileTreeLoader
implements DirectoryTreeLoader {
    private Hashtable m_pathnameToZipEntryMap = new Hashtable();
    private File m_rootFile = null;
    private ZipFile m_zipFile = null;
    private String m_currentDirectory = null;
    private InputStream m_currentlyOpenStream = null;

    private static String getCanonicalPathname(String pathname) {
        int index;
        pathname = pathname.replace('\\', '/');
        while ((index = pathname.indexOf("//")) != -1) {
            pathname = String.valueOf(pathname.substring(0, index + 1)) + pathname.substring(index + 2);
        }
        if (pathname.charAt(0) == '/') {
            pathname = pathname.substring(1);
        }
        return pathname;
    }

    @Override
    public void open(Object pathname) throws IllegalArgumentException, IOException {
        if (this.m_zipFile != null) {
            this.close();
        }
        if (pathname instanceof String) {
            this.m_rootFile = new File((String)pathname);
        } else if (pathname instanceof File) {
            this.m_rootFile = (File)pathname;
        } else {
            if (pathname == null) {
                throw new IllegalArgumentException(Messages.getString("pathname_is_null"));
            }
            throw new IllegalArgumentException(Messages.getString("pathname_must_be_an_instance_of_String_or_java_io_File"));
        }
        this.m_zipFile = new ZipFile(this.m_rootFile);
        this.m_currentDirectory = "";
        this.m_currentlyOpenStream = null;
        this.m_pathnameToZipEntryMap.clear();
        Enumeration<? extends ZipEntry> enum0 = this.m_zipFile.entries();
        while (enum0.hasMoreElements()) {
            ZipEntry zipEntry = enum0.nextElement();
            String encoding = new String(zipEntry.getName().getBytes("UTF-8"), "ISO-8859-1");
            String encoding1 = new String(zipEntry.getName().getBytes(), "UTF-8");
            String encoding2 = new String(zipEntry.getName().getBytes("UTF-8"), "UTF-8");
            String name = new String(zipEntry.getName().getBytes("UTF-8"), "ISO-8859-1");
            String path = new String(ZipFileTreeLoader.getCanonicalPathname(name));
            this.m_pathnameToZipEntryMap.put(path, zipEntry);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_zipFile != null) {
            this.closeCurrentFile();
            this.m_zipFile.close();
            this.m_zipFile = null;
        }
    }

    @Override
    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        if (pathname == null) {
            pathname = "";
        } else if (pathname.length() > 0) {
            if (pathname.charAt(0) != '/' && pathname.charAt(0) != '\\') {
                pathname = String.valueOf(this.m_currentDirectory) + pathname;
            }
            if (!(pathname = ZipFileTreeLoader.getCanonicalPathname(pathname)).endsWith("/")) {
                pathname = String.valueOf(pathname) + "/";
            }
            if (!pathname.startsWith("/")) {
                pathname = "/" + pathname;
            }
        }
        try {
            String utf8;
            this.m_currentDirectory = utf8 = new String(pathname.getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public static String detectEncoding(byte[] bytes) {
        String DEFAULT_ENCODING = "UTF-8";
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        return encoding;
    }

    @Override
    public InputStream readFile(String filename) throws IllegalArgumentException, IOException {
        String utf8;
        this.closeCurrentFile();
        String pathname = ZipFileTreeLoader.getCanonicalPathname(String.valueOf(this.m_currentDirectory) + filename);
        ZipEntry zipEntry = (ZipEntry)this.m_pathnameToZipEntryMap.get(pathname);
        String enc = ZipFileTreeLoader.detectEncoding(pathname.getBytes());
        if (zipEntry == null) {
            utf8 = new String(pathname.getBytes("UTF-8"), "ISO-8859-1");
            zipEntry = (ZipEntry)this.m_pathnameToZipEntryMap.get(utf8);
        }
        if (zipEntry == null) {
            utf8 = new String(pathname.getBytes("UTF-8"), "UTF-8");
            zipEntry = (ZipEntry)this.m_pathnameToZipEntryMap.get(utf8);
        }
        if (zipEntry != null) {
            this.m_currentlyOpenStream = this.m_zipFile.getInputStream(zipEntry);
            return this.m_currentlyOpenStream;
        }
        throw new FileNotFoundException(String.valueOf(Messages.getString("Not_Found__")) + pathname);
    }

    @Override
    public void closeCurrentFile() throws IOException {
        if (this.m_currentlyOpenStream != null) {
            this.m_currentlyOpenStream.close();
            this.m_currentlyOpenStream = null;
        }
    }

    @Override
    public String[] getFilesInCurrentDirectory() {
        throw new RuntimeException(Messages.getString("not_implemented"));
    }

    @Override
    public String[] getDirectoriesInCurrentDirectory() {
        throw new RuntimeException(Messages.getString("not_implemented"));
    }

    @Override
    public boolean isKeepFileSupported() {
        return true;
    }

    static Object getKeepKey(File file, String currentDirectory, String filename) {
        return String.valueOf(file.getAbsolutePath()) + "____" + currentDirectory + filename;
    }

    @Override
    public Object getKeepKey(String filename) {
        return ZipFileTreeLoader.getKeepKey(this.m_rootFile, this.m_currentDirectory, filename);
    }
}

