/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTreeStorer
implements DirectoryTreeStorer {
    protected ZipOutputStream zipOut = null;
    protected String currentDirectory = null;
    protected ZipEntry currentEntry = null;

    protected boolean isCompressed() {
        return true;
    }

    @Override
    public void open(Object pathname) throws IllegalArgumentException, IOException {
        if (this.zipOut != null) {
            this.close();
        }
        OutputStream out = null;
        if (pathname instanceof String) {
            out = new FileOutputStream((String)pathname);
        } else if (pathname instanceof File) {
            out = new FileOutputStream((File)pathname);
        } else if (pathname instanceof OutputStream) {
            out = (OutputStream)pathname;
        } else {
            throw new IllegalArgumentException(Messages.getString("pathname_must_be_an_instance_of_String__java_io_File__or_java_io_OutputStream"));
        }
        this.zipOut = new ZipOutputStream(new BufferedOutputStream(out));
        if (!this.isCompressed()) {
            this.zipOut.setMethod(0);
        }
        this.currentDirectory = "";
    }

    @Override
    public void close() throws IOException {
        if (this.zipOut != null) {
            this.closeCurrentFile();
            this.zipOut.flush();
            this.zipOut.finish();
            this.zipOut.close();
            this.zipOut = null;
        }
    }

    @Override
    public void createDirectory(String pathname) throws IllegalArgumentException, IOException {
        if (pathname.indexOf(47) != -1 || pathname.indexOf(92) != -1) {
            throw new IllegalArgumentException(Messages.getString("pathname_cannot_contain_path_separators"));
        }
        if (pathname.length() <= 0) {
            throw new IllegalArgumentException(Messages.getString("pathname_has_no_length"));
        }
        String path = new String((String.valueOf(this.currentDirectory) + pathname + "/").getBytes(), "ISO-8859-1");
        ZipEntry newEntry = new ZipEntry(path);
        if (this.zipOut == null) {
            throw new IOException(Messages.getString("No_zip_file_currently_open"));
        }
        this.zipOut.putNextEntry(newEntry);
        this.zipOut.closeEntry();
    }

    @Override
    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        if (pathname == null) {
            pathname = "";
        } else if (pathname.length() > 0) {
            int index;
            pathname = pathname.replace('\\', '/');
            while ((index = pathname.indexOf("//")) != -1) {
                pathname = String.valueOf(pathname.substring(0, index + 1)) + pathname.substring(index + 2);
            }
            if (!(pathname = pathname.charAt(0) == '/' ? pathname.substring(1) : String.valueOf(this.currentDirectory) + pathname).endsWith("/")) {
                pathname = String.valueOf(pathname) + "/";
            }
            if (!pathname.startsWith("/")) {
                pathname = "/" + pathname;
            }
        }
        this.currentDirectory = pathname;
    }

    @Override
    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public OutputStream createFile(String filename, boolean compressItIfYouGotIt) throws IllegalArgumentException, IOException {
        if (this.zipOut != null) {
            this.currentEntry = new ZipEntry(String.valueOf(this.currentDirectory) + filename);
            if (!this.isCompressed()) {
                this.currentEntry.setMethod(0);
            }
        } else {
            throw new IOException(Messages.getString("No_zip_file_currently_open"));
        }
        this.zipOut.putNextEntry(this.currentEntry);
        return this.zipOut;
    }

    @Override
    public void closeCurrentFile() throws IOException {
        if (this.currentEntry != null) {
            this.zipOut.flush();
            this.zipOut.closeEntry();
            this.currentEntry = null;
        }
    }

    @Override
    public Object getKeepKey(String filename) {
        return null;
    }

    @Override
    public boolean isKeepFileSupported() {
        return false;
    }

    @Override
    public void keepFile(String filename) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        throw new KeepFileNotSupportedException();
    }
}

