/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.Color;
import javax.vecmath.Matrix4d;

public class Interpolator {
    public static int interpolate(int a, int b, double portion) {
        return a + (int)((double)(b - a) * portion);
    }

    public static double interpolate(double a, double b, double portion) {
        return a + (b - a) * portion;
    }

    public static Number interpolate(Number a, Number b, double portion) {
        return new Double(Interpolator.interpolate(a.doubleValue(), b.doubleValue(), portion));
    }

    public static double[] interpolate(double[] a, double[] b, double portion) {
        if (a.length != b.length) {
            return null;
        }
        double[] v = new double[a.length];
        int i = 0;
        while (i < a.length) {
            v[i] = Interpolator.interpolate(a[i], b[i], portion);
            ++i;
        }
        return v;
    }

    public static double[][] interpolate(double[][] a, double[][] b, double portion) {
        if (a.length != b.length) {
            return null;
        }
        double[][] m = new double[a.length][];
        int i = 0;
        while (i < a.length) {
            if (a[i].length != b[i].length) {
                return null;
            }
            m[i] = new double[a[i].length];
            int j = 0;
            while (j < a[i].length) {
                m[i][j] = Interpolator.interpolate(a[i][j], b[i][j], portion);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static Color interpolate(Color a, Color b, double portion) {
        return new Color(Math.max(0, Math.min(Interpolator.interpolate(a.getRed(), b.getRed(), portion), 255)), Math.max(0, Math.min(Interpolator.interpolate(a.getGreen(), b.getGreen(), portion), 255)), Math.max(0, Math.min(Interpolator.interpolate(a.getBlue(), b.getBlue(), portion), 255)));
    }

    public static Object interpolate(Object a, Object b, double portion) {
        if (a instanceof Matrix4d) {
            Matrix44 ai = a instanceof Matrix44 ? (Matrix44)a : new Matrix44((Matrix4d)a);
            Matrix44 bi = b instanceof Matrix44 ? (Matrix44)b : new Matrix44((Matrix4d)b);
            return ai.interpolate(bi, portion);
        }
        if (a instanceof Interpolable) {
            return ((Interpolable)a).interpolate((Interpolable)b, portion);
        }
        if (a instanceof Number) {
            return Interpolator.interpolate((Number)a, (Number)b, portion);
        }
        if (a instanceof Color) {
            return Interpolator.interpolate((Color)a, (Color)b, portion);
        }
        if (a instanceof double[]) {
            return Interpolator.interpolate((double[])a, (double[])b, portion);
        }
        if (a instanceof double[][]) {
            return Interpolator.interpolate((double[][])a, (double[][])b, portion);
        }
        return b;
    }
}

