/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media;

import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Player;
import edu.cmu.cs.stage3.media.event.DataSourceEvent;
import edu.cmu.cs.stage3.media.event.DataSourceListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractDataSource
implements DataSource {
    private String m_extension;
    private double m_duration = Double.NaN;
    private double m_durationHint = Double.NaN;
    private boolean m_isCompressionWorthwhile;
    private Vector m_dataSourceListeners = new Vector();
    private DataSourceListener[] m_dataSourceListenerArray;
    private Vector m_players = new Vector();

    protected abstract Player createPlayer();

    protected AbstractDataSource(String extension) {
        this.m_extension = extension;
        this.m_isCompressionWorthwhile = !this.m_extension.equalsIgnoreCase("mp3");
    }

    @Override
    public String getExtension() {
        return this.m_extension;
    }

    @Override
    public void addDataSourceListener(DataSourceListener l) {
        this.m_dataSourceListeners.addElement(l);
        this.m_dataSourceListenerArray = null;
    }

    @Override
    public void removeDataSourceListener(DataSourceListener l) {
        this.m_dataSourceListeners.removeElement(l);
        this.m_dataSourceListenerArray = null;
    }

    @Override
    public DataSourceListener[] getDataSourceListeners() {
        if (this.m_dataSourceListenerArray == null) {
            this.m_dataSourceListenerArray = new DataSourceListener[this.m_dataSourceListeners.size()];
            this.m_dataSourceListeners.copyInto(this.m_dataSourceListenerArray);
        }
        return this.m_dataSourceListenerArray;
    }

    private Player addNewPlayer() {
        Player player = this.createPlayer();
        this.m_players.addElement(player);
        return player;
    }

    private int getRealizedPlayerCount() {
        int realizedPlayerCount = 0;
        Enumeration enum0 = this.m_players.elements();
        while (enum0.hasMoreElements()) {
            Player player = (Player)enum0.nextElement();
            if (player.getState() < 300) continue;
            ++realizedPlayerCount;
        }
        return realizedPlayerCount;
    }

    @Override
    public int waitForRealizedPlayerCount(int playerCount, long timeout) {
        while (this.m_players.size() < playerCount) {
            this.addNewPlayer();
        }
        Enumeration enum0 = this.m_players.elements();
        while (enum0.hasMoreElements()) {
            Player player = (Player)enum0.nextElement();
            player.realize();
        }
        return this.getRealizedPlayerCount();
    }

    @Override
    public Player acquirePlayer() {
        Player availablePlayer = null;
        Enumeration enum0 = this.m_players.elements();
        while (enum0.hasMoreElements()) {
            Player player = (Player)enum0.nextElement();
            if (!player.isAvailable()) continue;
            availablePlayer = player;
            break;
        }
        if (availablePlayer == null) {
            availablePlayer = this.addNewPlayer();
        }
        availablePlayer.setIsAvailable(false);
        return availablePlayer;
    }

    @Override
    public double getDuration(boolean useHintIfNecessary) {
        if (useHintIfNecessary) {
            if (Double.isNaN(this.m_duration)) {
                return this.m_durationHint;
            }
            return this.m_duration;
        }
        return this.m_duration;
    }

    @Override
    public double getDurationHint() {
        return this.m_durationHint;
    }

    @Override
    public void setDurationHint(double durationHint) {
        this.m_durationHint = durationHint;
    }

    @Override
    public boolean isCompressionWorthwhile() {
        return this.m_isCompressionWorthwhile;
    }

    protected void fireDurationUpdatedIfNecessary(double duration) {
        if (duration != this.m_duration) {
            this.m_duration = duration;
            DataSourceEvent e = new DataSourceEvent(this);
            DataSourceListener[] dataSourceListeners = this.getDataSourceListeners();
            int i = 0;
            while (i < dataSourceListeners.length) {
                dataSourceListeners[i].durationUpdated(e);
                ++i;
            }
        }
    }
}

