/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media;

import edu.cmu.cs.stage3.media.AbstractDataSource;
import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Player;
import edu.cmu.cs.stage3.media.event.PlayerEvent;
import edu.cmu.cs.stage3.media.event.PlayerListener;
import java.util.Vector;

public abstract class AbstractPlayer
implements Player {
    private boolean m_isAvailable = true;
    private AbstractDataSource m_dataSource;
    private Vector m_playerListeners = new Vector();
    private PlayerListener[] m_playerListenerArray;
    private double m_beginTime = 0.0;
    private double m_endTime = Double.NaN;

    protected AbstractPlayer(AbstractDataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    @Override
    public boolean isAvailable() {
        return this.m_isAvailable;
    }

    @Override
    public void setIsAvailable(boolean isAvailable) {
        this.m_isAvailable = isAvailable;
    }

    @Override
    public double getBeginTime() {
        return this.m_beginTime;
    }

    @Override
    public void setBeginTime(double beginTime) {
        this.m_beginTime = beginTime;
    }

    @Override
    public double getEndTime() {
        return this.m_endTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.m_endTime = endTime;
    }

    @Override
    public void startFromBeginning() {
        this.setCurrentTime(this.getBeginTime());
        this.start();
    }

    @Override
    public void addPlayerListener(PlayerListener l) {
        this.m_playerListeners.addElement(l);
        this.m_playerListenerArray = null;
    }

    @Override
    public void removePlayerListener(PlayerListener l) {
        this.m_playerListeners.removeElement(l);
        this.m_playerListenerArray = null;
    }

    @Override
    public PlayerListener[] getPlayerListeners() {
        if (this.m_playerListenerArray == null) {
            this.m_playerListenerArray = new PlayerListener[this.m_playerListeners.size()];
            this.m_playerListeners.copyInto(this.m_playerListenerArray);
        }
        return this.m_playerListenerArray;
    }

    protected void fireDurationUpdated() {
        this.m_dataSource.fireDurationUpdatedIfNecessary(this.getDuration());
    }

    protected void fireEndReached() {
        PlayerEvent e = new PlayerEvent(this);
        PlayerListener[] playerListeners = this.getPlayerListeners();
        int i = 0;
        while (i < playerListeners.length) {
            playerListeners[i].endReached(e);
            ++i;
        }
    }

    protected void fireStateChanged() {
        PlayerEvent e = new PlayerEvent(this);
        PlayerListener[] playerListeners = this.getPlayerListeners();
        int i = 0;
        while (i < playerListeners.length) {
            playerListeners[i].stateChanged(e);
            ++i;
        }
    }
}

