/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media.jmfmedia;

import java.io.IOException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

class ByteArraySeekablePullSourceStream
implements PullSourceStream,
Seekable {
    private static final ContentDescriptor RAW_CONTENT_DISCRIPTOR = new ContentDescriptor("raw");
    private byte[] m_data;
    private long m_location;
    private long m_size;

    public ByteArraySeekablePullSourceStream(byte[] data) {
        this.m_data = data;
        this.m_location = 0L;
        this.m_size = data.length;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        long bytesLeft = this.m_size - this.m_location;
        if (bytesLeft == 0L) {
            return -1;
        }
        int intBytesLeft = (int)bytesLeft;
        int toRead = length;
        if (intBytesLeft < length) {
            toRead = intBytesLeft;
        }
        System.arraycopy(this.m_data, (int)this.m_location, buffer, offset, toRead);
        this.m_location += (long)toRead;
        return toRead;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    public ContentDescriptor getContentDescriptor() {
        return RAW_CONTENT_DISCRIPTOR;
    }

    public boolean endOfStream() {
        return this.m_location == this.m_size;
    }

    public long getContentLength() {
        return this.m_size;
    }

    public boolean willReadBlock() {
        return this.endOfStream();
    }

    public boolean isRandomAccess() {
        return true;
    }

    public long seek(long where) {
        this.m_location = where > this.m_size ? this.m_size : where;
        return this.m_location;
    }

    public long tell() {
        return this.m_location;
    }
}

