/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media.jmfmedia;

import edu.cmu.cs.stage3.media.AbstractDataSource;
import edu.cmu.cs.stage3.media.jmfmedia.ByteArrayDataSource;
import edu.cmu.cs.stage3.media.jmfmedia.Player;
import java.util.Dictionary;
import java.util.Hashtable;

public class DataSource
extends AbstractDataSource {
    private static Dictionary s_extensionToContentTypeMap = new Hashtable();
    private ByteArrayDataSource m_jmfDataSource;

    static {
        s_extensionToContentTypeMap = new Hashtable();
        s_extensionToContentTypeMap.put("mp3", "audio.mpeg");
        s_extensionToContentTypeMap.put("wav", "audio.x_wav");
    }

    public DataSource(byte[] data, String extension) {
        super(extension);
        String contentType = (String)s_extensionToContentTypeMap.get(extension.toLowerCase());
        try {
            this.m_jmfDataSource = new ByteArrayDataSource(data, contentType);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public byte[] getData() {
        return this.m_jmfDataSource.getData();
    }

    public javax.media.protocol.DataSource getJMFDataSource() {
        return this.m_jmfDataSource;
    }

    @Override
    protected edu.cmu.cs.stage3.media.Player createPlayer() {
        return new Player(this);
    }
}

