/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.media.nullmedia;

import edu.cmu.cs.stage3.media.AbstractPlayer;
import edu.cmu.cs.stage3.media.nullmedia.DataSource;

public class Player
extends AbstractPlayer {
    private double m_currentTime = 0.0;
    private int m_state = 300;

    public Player(DataSource dataSource) {
        super(dataSource);
    }

    public double waitForTimeRemaining(long timeout) {
        return this.m_currentTime - this.getActualEndTime();
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    private void setState(int state) {
        if (this.m_state != state) {
            this.m_state = state;
            this.fireStateChanged();
        }
    }

    @Override
    public double getCurrentTime() {
        return this.m_currentTime;
    }

    @Override
    public void setCurrentTime(double currentTime) {
        this.m_currentTime = currentTime;
    }

    @Override
    public double getDuration() {
        return this.getDataSource().getDuration(true);
    }

    private double getActualEndTime() {
        double endTime = this.getEndTime();
        if (Double.isNaN(endTime)) {
            endTime = this.getDuration();
        }
        return endTime;
    }

    private void setCurrentTimeToEnd() {
        this.setCurrentTime(this.getActualEndTime());
        this.setState(300);
        this.fireEndReached();
    }

    @Override
    public void setVolumeLevel(float volumeLevel) {
    }

    @Override
    public void setRate(float rate) {
    }

    public void setPan(float pan) {
    }

    @Override
    public void prefetch() {
    }

    @Override
    public void realize() {
    }

    @Override
    public void start() {
        this.setState(300);
        this.setState(600);
        final double timeRemaining = this.waitForTimeRemaining(0L);
        if (Double.isNaN(timeRemaining)) {
            this.setCurrentTimeToEnd();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            Thread.sleep((long)(timeRemaining * 1000.0));
                        }
                        catch (InterruptedException interruptedException) {
                            Player.this.setCurrentTimeToEnd();
                        }
                    }
                    finally {
                        Player.this.setCurrentTimeToEnd();
                    }
                }
            }.start();
        }
    }

    @Override
    public void stop() {
        this.setState(300);
    }
}

