/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.math.CatmullRomCubic;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import edu.cmu.cs.stage3.pratt.maxkeyframing.SimpleKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Spline;
import java.util.HashMap;

public class CatmullRomSpline
extends Spline {
    protected SimpleKey[] keys;
    protected CatmullRomCubic[][] curves;
    protected HashMap curveMap = new HashMap();
    protected int numComponents;

    public boolean addKey(SimpleKey key) {
        boolean result = super.addKey(key);
        this.updateKeys();
        return result;
    }

    public boolean removeKey(SimpleKey key) {
        boolean result = super.removeKey(key);
        this.updateKeys();
        return result;
    }

    public void updateKeys() {
        this.keys = (SimpleKey[])this.getKeyArray(new SimpleKey[0]);
        this.curveMap.clear();
        if (this.keys != null) {
            this.numComponents = this.keys[0].getValueComponents().length;
            this.curves = new CatmullRomCubic[this.keys.length - 1][this.numComponents];
            int i = 0;
            while (i < this.curves.length) {
                SimpleKey keyLast = this.keys[Math.max(i - 1, 0)];
                SimpleKey keyThis = this.keys[i];
                SimpleKey keyNext = this.keys[i + 1];
                SimpleKey keyNextNext = this.keys[Math.min(i + 2, this.keys.length - 1)];
                this.curveMap.put(keyThis, new Integer(i));
                int j = 0;
                while (j < this.numComponents) {
                    double pLast = keyLast.getValueComponents()[j];
                    double pThis = keyThis.getValueComponents()[j];
                    double pNext = keyNext.getValueComponents()[j];
                    double pNextNext = keyNextNext.getValueComponents()[j];
                    this.curves[i][j] = new CatmullRomCubic(pLast, pThis, pNext, pNextNext);
                    ++j;
                }
                ++i;
            }
        } else {
            this.curves = null;
        }
    }

    @Override
    public Object getSample(double t) {
        if (t <= 0.0) {
            Key key = this.getFirstKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else if (t >= this.getDuration()) {
            Key key = this.getLastKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else {
            Key[] boundingKeys = this.getBoundingKeys(t);
            if (boundingKeys != null) {
                double timeSpan = boundingKeys[1].getTime() - boundingKeys[0].getTime();
                double portion = (t - boundingKeys[0].getTime()) / timeSpan;
                Object o = this.curveMap.get(boundingKeys[0]);
                if (o instanceof Integer) {
                    int i = (Integer)o;
                    double[] components = new double[this.numComponents];
                    int j = 0;
                    while (j < this.numComponents) {
                        components[j] = this.curves[i][j].evaluate(portion);
                        ++j;
                    }
                    return boundingKeys[0].createSample(components);
                }
            }
        }
        return null;
    }
}

