/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import edu.cmu.cs.stage3.pratt.maxkeyframing.SimpleKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Spline;

public class LinearSpline
extends Spline {
    public boolean addKey(SimpleKey key) {
        return super.addKey(key);
    }

    public boolean removeKey(SimpleKey key) {
        return super.removeKey(key);
    }

    @Override
    public Object getSample(double t) {
        if (t <= 0.0) {
            Key key = this.getFirstKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else if (t >= this.getDuration()) {
            Key key = this.getLastKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else {
            Key[] boundingKeys = this.getBoundingKeys(t);
            if (boundingKeys != null) {
                double timeSpan = boundingKeys[1].getTime() - boundingKeys[0].getTime();
                double portion = (t - boundingKeys[0].getTime()) / timeSpan;
                double[] prevComponents = boundingKeys[0].getValueComponents();
                double[] nextComponents = boundingKeys[1].getValueComponents();
                double[] components = new double[prevComponents.length];
                int j = 0;
                while (j < prevComponents.length) {
                    components[j] = prevComponents[j] + (nextComponents[j] - prevComponents[j]) * portion;
                    ++j;
                }
                return boundingKeys[0].createSample(components);
            }
        }
        return null;
    }
}

