/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.pratt.maxkeyframing.TCBKey;
import java.util.StringTokenizer;

public class QuaternionTCBKey
extends TCBKey {
    private Quaternion qSample = new Quaternion();

    public QuaternionTCBKey(double time, Quaternion value, double tension, double continuity, double bias) {
        super(time, new double[]{value.x, value.y, value.z, value.w}, tension, continuity, bias);
    }

    @Override
    public Object createSample(double[] components) {
        double lengthSquared = components[0] * components[0] + components[1] * components[1] + components[2] * components[2] + components[3] * components[3];
        if (lengthSquared == 1.0) {
            this.qSample.x = components[0];
            this.qSample.y = components[1];
            this.qSample.z = components[2];
            this.qSample.w = components[3];
            return this.qSample;
        }
        double length = Math.sqrt(lengthSquared);
        this.qSample.x = components[0] / length;
        this.qSample.y = components[1] / length;
        this.qSample.z = components[2] / length;
        this.qSample.w = components[3] / length;
        return this.qSample;
    }

    public static QuaternionTCBKey valueOf(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t,[]");
        String className = st.nextToken();
        double time = Double.parseDouble(st.nextToken());
        Quaternion value = new Quaternion(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
        double tension = Double.parseDouble(st.nextToken());
        double continuity = Double.parseDouble(st.nextToken());
        double bias = Double.parseDouble(st.nextToken());
        return new QuaternionTCBKey(time, value, tension, continuity, bias);
    }
}

