/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.io.TokenBlock;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class Spline {
    private TreeSet keys;
    private Comparator keyComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Key && o2 instanceof Key) {
                Key key1 = (Key)o1;
                Key key2 = (Key)o2;
                if (key1.getTime() < key2.getTime()) {
                    return -1;
                }
                if (key1.getTime() > key2.getTime()) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException(String.valueOf(Key.class.getName()) + " " + Messages.getString("required_"));
        }
    };
    private Key recentKey;
    private Key[] boundingKeys = new Key[2];

    protected Spline() {
        this.keys = new TreeSet(this.keyComparator);
    }

    protected boolean addKey(Key key) {
        return this.keys.add(key);
    }

    protected boolean removeKey(Key key) {
        return this.keys.remove(key);
    }

    public void clearKeys() {
        this.keys.clear();
    }

    public Key[] getKeyArray(Key[] keyArray) {
        return this.keys.toArray(keyArray);
    }

    public Key[] getBoundingKeys(double time) {
        Iterator iter;
        Key prevKey = null;
        Key nextKey = null;
        if (this.keys.size() == 1) {
            this.boundingKeys[0] = prevKey = (nextKey = (Key)this.keys.first());
            this.boundingKeys[1] = nextKey;
            return this.boundingKeys;
        }
        if (this.recentKey != null && (iter = this.keys.tailSet(this.recentKey).iterator()).hasNext()) {
            nextKey = (Key)iter.next();
            while (iter.hasNext()) {
                prevKey = nextKey;
                nextKey = (Key)iter.next();
                if (!(time >= prevKey.getTime()) || !(time < nextKey.getTime())) continue;
                this.recentKey = prevKey;
                this.boundingKeys[0] = prevKey;
                this.boundingKeys[1] = nextKey;
                return this.boundingKeys;
            }
        }
        if ((iter = this.keys.iterator()).hasNext()) {
            nextKey = (Key)iter.next();
            while (iter.hasNext()) {
                prevKey = nextKey;
                nextKey = (Key)iter.next();
                if (!(time >= prevKey.getTime()) || !(time < nextKey.getTime())) continue;
                this.recentKey = prevKey;
                this.boundingKeys[0] = prevKey;
                this.boundingKeys[1] = nextKey;
                return this.boundingKeys;
            }
        }
        return null;
    }

    public Key getFirstKey() {
        return (Key)this.keys.first();
    }

    public Key getLastKey() {
        return (Key)this.keys.last();
    }

    public double getDuration() {
        return this.getLastTime();
    }

    public double getFirstTime() {
        if (!this.keys.isEmpty()) {
            return this.getFirstKey().getTime();
        }
        return 0.0;
    }

    public double getLastTime() {
        if (!this.keys.isEmpty()) {
            return this.getLastKey().getTime();
        }
        return 0.0;
    }

    public void scaleKeyValueComponents(double scaleFactor) {
        for (Key key : this.keys) {
            double[] valueComponents = key.getValueComponents();
            int i = 0;
            while (i < valueComponents.length) {
                int n = i++;
                valueComponents[n] = valueComponents[n] * scaleFactor;
            }
        }
    }

    public abstract Object getSample(double var1);

    public String toString() {
        StringBuffer repr = new StringBuffer();
        repr.append("{spline}");
        repr.append("{splineType}");
        repr.append(this.getClass().getName());
        repr.append("{/splineType}");
        repr.append("{keys}");
        for (Key key : this.keys) {
            repr.append("{key}");
            repr.append("{type}");
            repr.append(key.getClass().getName());
            repr.append("{/type}");
            repr.append("{data}");
            repr.append(key.toString());
            repr.append("{/data}");
            repr.append("{/key}");
        }
        repr.append("{/keys}");
        repr.append("{/spline}");
        return repr.toString();
    }

    public static Spline valueOf(String s) {
        s = s.replace('{', '<');
        s = s.replace('}', '>');
        TokenBlock splineBlock = TokenBlock.getTokenBlock(0, s);
        TokenBlock splineTypeBlock = TokenBlock.getTokenBlock(0, splineBlock.tokenContents);
        TokenBlock keysBlock = TokenBlock.getTokenBlock(splineTypeBlock.tokenEndIndex, splineBlock.tokenContents);
        Spline spline = null;
        Method addKeyMethod = null;
        try {
            Class<?> splineClass = Class.forName(splineTypeBlock.tokenContents);
            spline = (Spline)splineClass.newInstance();
            addKeyMethod = null;
            Method[] methods = splineClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equals("addKey")) {
                    addKeyMethod = methods[i];
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        if (addKeyMethod == null) {
            System.err.println(String.valueOf(Messages.getString("Unable_to_find_addKey_method_for_")) + spline);
            return null;
        }
        int beginIndex = 0;
        TokenBlock keyBlock = TokenBlock.getTokenBlock(beginIndex, keysBlock.tokenContents);
        while (keyBlock.tokenContents != null) {
            TokenBlock typeBlock = TokenBlock.getTokenBlock(0, keyBlock.tokenContents);
            TokenBlock dataBlock = TokenBlock.getTokenBlock(typeBlock.tokenEndIndex, keyBlock.tokenContents);
            try {
                Class<?> keyClass = Class.forName(typeBlock.tokenContents);
                Method valueOfMethod = keyClass.getMethod("valueOf", String.class);
                Object key = valueOfMethod.invoke(null, dataBlock.tokenContents);
                addKeyMethod.invoke((Object)spline, key);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            beginIndex = keyBlock.tokenEndIndex;
            keyBlock = TokenBlock.getTokenBlock(beginIndex, keysBlock.tokenContents);
        }
        return spline;
    }
}

