/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.pratt.maxkeyframing;

import edu.cmu.cs.stage3.math.HermiteCubic;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Key;
import edu.cmu.cs.stage3.pratt.maxkeyframing.QuaternionTCBKey;
import edu.cmu.cs.stage3.pratt.maxkeyframing.Spline;
import edu.cmu.cs.stage3.pratt.maxkeyframing.TCBKey;
import java.util.HashMap;

public class TCBSpline
extends Spline {
    protected TCBKey[] keys;
    protected HermiteCubic[][] curves;
    protected HashMap curveMap = new HashMap();
    protected int numComponents;

    public boolean addKey(TCBKey key) {
        boolean result = super.addKey(key);
        this.updateKeys();
        return result;
    }

    public boolean removeKey(TCBKey key) {
        boolean result = super.removeKey(key);
        this.updateKeys();
        return result;
    }

    public void updateKeys() {
        this.keys = (TCBKey[])this.getKeyArray(new TCBKey[0]);
        this.curveMap.clear();
        if (this.keys != null) {
            this.numComponents = this.keys[0].getValueComponents().length;
            this.curves = new HermiteCubic[this.keys.length - 1][this.numComponents];
            int i = 0;
            while (i < this.curves.length) {
                TCBKey keyLast = this.keys[Math.max(i - 1, 0)];
                TCBKey keyThis = this.keys[i];
                TCBKey keyNext = this.keys[i + 1];
                TCBKey keyNextNext = this.keys[Math.min(i + 2, this.keys.length - 1)];
                this.curveMap.put(keyThis, new Integer(i));
                int j = 0;
                while (j < this.numComponents) {
                    double pLast = keyLast.getValueComponents()[j];
                    double pThis = keyThis.getValueComponents()[j];
                    double pNext = keyNext.getValueComponents()[j];
                    double pNextNext = keyNextNext.getValueComponents()[j];
                    double dThis = this.getTangentAtKey(keyThis, pLast, pThis, pNext);
                    double dNext = this.getTangentAtKey(keyNext, pThis, pNext, pNextNext);
                    this.curves[i][j] = new HermiteCubic(pThis, pNext, dThis, dNext);
                    ++j;
                }
                ++i;
            }
        } else {
            this.curves = null;
        }
    }

    private double getTangentAtKey(TCBKey key, double pLast, double pThis, double pNext) {
        double t = key.getTension();
        double c = key.getContinuity();
        double b = key.getBias();
        double ds = (1.0 - t) * (1.0 - c) * (1.0 + b) / 2.0 * (pThis - pLast) + (1.0 - t) * (1.0 + c) * (1.0 - b) / 2.0 * (pNext - pThis);
        double dd = (1.0 - t) * (1.0 + c) * (1.0 + b) / 2.0 * (pThis - pLast) + (1.0 - t) * (1.0 - c) * (1.0 - b) / 2.0 * (pNext - pThis);
        return (ds + dd) / 2.0;
    }

    public void correctForMAXRelativeKeys() {
        Matrix33 lastRot = null;
        TCBKey[] keys = (TCBKey[])this.getKeyArray(new TCBKey[0]);
        int i = 0;
        while (i < keys.length) {
            Quaternion thisQ = (Quaternion)keys[i].createSample(keys[i].getValueComponents());
            if (i > 0) {
                Quaternion realQ = Matrix33.multiply(lastRot, thisQ.getMatrix33()).getQuaternion();
                QuaternionTCBKey realKey = new QuaternionTCBKey(keys[i].getTime(), realQ, keys[i].getTension(), keys[i].getContinuity(), keys[i].getBias());
                this.removeKey(keys[i]);
                this.addKey(realKey);
                lastRot = realQ.getMatrix33();
            } else {
                lastRot = thisQ.getMatrix33();
            }
            ++i;
        }
    }

    @Override
    public Object getSample(double t) {
        if (t <= 0.0) {
            Key key = this.getFirstKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else if (t >= this.getDuration()) {
            Key key = this.getLastKey();
            if (key != null) {
                return key.createSample(key.getValueComponents());
            }
        } else {
            Key[] boundingKeys = this.getBoundingKeys(t);
            if (boundingKeys != null) {
                double timeSpan = boundingKeys[1].getTime() - boundingKeys[0].getTime();
                double portion = (t - boundingKeys[0].getTime()) / timeSpan;
                Object o = this.curveMap.get(boundingKeys[0]);
                if (o instanceof Integer) {
                    int i = (Integer)o;
                    double[] components = new double[this.numComponents];
                    int j = 0;
                    while (j < this.numComponents) {
                        components[j] = this.curves[i][j].evaluate(portion);
                        ++j;
                    }
                    return boundingKeys[0].createSample(components);
                }
            }
        }
        return null;
    }
}

