/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.scheduler;

import edu.cmu.cs.stage3.scheduler.Scheduler;
import edu.cmu.cs.stage3.scheduler.SchedulerEvent;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;

public class SchedulerThread
extends Thread {
    private Scheduler m_scheduler;
    private EventQueue m_eventQueue;
    private SchedulerEvent m_schedulerEvent;
    private boolean m_continue;
    private long m_sleepMillis = 15L;

    public SchedulerThread(Scheduler scheduler) {
        this.m_scheduler = scheduler;
        this.m_eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        this.m_schedulerEvent = new SchedulerEvent(this);
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void markToStop() {
        this.m_continue = false;
    }

    public long getSleepMillis() {
        return this.m_sleepMillis;
    }

    public void setSleepMillis(long sleepMillis) {
        this.m_sleepMillis = sleepMillis;
    }

    @Override
    public void run() {
        this.m_continue = true;
        do {
            try {
                AWTEvent e = this.m_eventQueue.peekEvent(this.m_schedulerEvent.getID());
                if (e == null) {
                    this.m_eventQueue.postEvent(this.m_schedulerEvent);
                    SchedulerThread.sleep(this.m_sleepMillis);
                    continue;
                }
                SchedulerThread.sleep(1L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                break;
            }
        } while (this.m_continue);
    }
}

