/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import movieMaker.MoviePlayer;

public class ButtonPanel
extends JPanel {
    private JList frameRateList = null;
    private JLabel frameRateLabel = null;
    private JButton nextButton = new JButton(Messages.getString("Next"));
    private JButton playButton = new JButton(Messages.getString("Play_Movie"));
    private JButton prevButton = new JButton(Messages.getString("Prev"));
    private JButton delBeforeButton = new JButton(Messages.getString("Delete_All_Previous"));
    private JButton delAfterButton = new JButton(Messages.getString("Delete_All_After"));
    private JButton writeQuicktimeButton = new JButton(Messages.getString("Write_Quicktime"));
    private JButton writeAVIButton = new JButton(Messages.getString("Write_AVI"));
    private MoviePlayer moviePlayer = null;

    public ButtonPanel(MoviePlayer player) {
        this.moviePlayer = player;
        this.add(this.prevButton);
        this.add(this.nextButton);
        this.frameRateLabel = new JLabel(Messages.getString("Frames_per_Second__"));
        this.add(this.frameRateLabel);
        String[] rates = new String[]{"16", "24", "30"};
        this.frameRateList = new JList<String>(rates);
        JScrollPane scrollPane = new JScrollPane(this.frameRateList);
        this.frameRateList.setSelectedIndex(0);
        this.frameRateList.setVisibleRowCount(1);
        this.frameRateList.setToolTipText(Messages.getString("The_number_of_frames_per_second_in_the_movie"));
        this.frameRateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String rateS = (String)ButtonPanel.this.frameRateList.getSelectedValue();
                int rate = Integer.parseInt(rateS);
                ButtonPanel.this.moviePlayer.setFrameRate(rate);
            }
        });
        this.add(scrollPane);
        this.add(this.playButton);
        this.add(this.delBeforeButton);
        this.add(this.delAfterButton);
        this.add(this.writeQuicktimeButton);
        this.add(this.writeAVIButton);
        this.nextButton.setToolTipText(Messages.getString("Click_to_see_the_next_frame"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.showNext();
            }
        });
        this.prevButton.setToolTipText(Messages.getString("Click_to_see_the_previous_frame"));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.showPrevious();
            }
        });
        this.playButton.setToolTipText(Messages.getString("Click_to_play_the_movie"));
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.playMovie();
            }
        });
        this.delBeforeButton.setToolTipText(Messages.getString("Click_to_delete_all_frames_before_the_current_one"));
        this.delBeforeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.delAllBefore();
            }
        });
        this.delAfterButton.setToolTipText(Messages.getString("Click_to_delete_all_frames_after_the_current_one"));
        this.delAfterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.delAllAfter();
            }
        });
        this.writeQuicktimeButton.setToolTipText(Messages.getString("Click_to_write_out_a_Quicktime_movie_from_the_frames"));
        this.writeQuicktimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.writeQuicktime();
            }
        });
        this.writeAVIButton.setToolTipText(Messages.getString("Click_to_write_out_an_AVI_movie_from_the_frames"));
        this.writeAVIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.moviePlayer.writeAVI();
            }
        });
    }
}

