/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import movieMaker.MoviePlayer;
import movieMaker.Picture;

public class FrameSequencer {
    private String directory;
    private String baseName = "frame";
    private int frameNumber = 1;
    private boolean shown = false;
    private MoviePlayer moviePlayer = null;
    private ArrayList pictureList = new ArrayList();
    private NumberFormat numberFormat = NumberFormat.getIntegerInstance();

    public FrameSequencer(String directory) {
        Collections.synchronizedList(this.pictureList);
        this.directory = directory;
        this.initFormatter();
        this.validateDirectory();
    }

    public FrameSequencer(String directory, String baseName) {
        this(directory);
        this.baseName = baseName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String dir) {
        this.directory = dir;
        this.initFormatter();
        this.validateDirectory();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        this.shown = value;
    }

    public int getNumFrames() {
        return this.pictureList.size();
    }

    public MoviePlayer getMoviePlayer() {
        return this.moviePlayer;
    }

    private void initFormatter() {
        this.numberFormat.setMinimumIntegerDigits(6);
        this.numberFormat.setGroupingUsed(false);
    }

    private void validateDirectory() {
        File directoryFile;
        char end = this.directory.charAt(this.directory.length() - 1);
        if (end != '/' && end != '\\') {
            this.directory = String.valueOf(this.directory) + '/';
        }
        if (!(directoryFile = new File(this.directory)).exists()) {
            directoryFile.mkdirs();
        }
    }

    public void addFrame(Picture picture) {
        this.pictureList.add(picture);
        ++this.frameNumber;
    }

    public Picture removeFrame() {
        if (this.pictureList.size() > 0) {
            return (Picture)this.pictureList.remove(0);
        }
        return null;
    }

    public void deleteLastFrame() {
        --this.frameNumber;
        File f = new File(String.valueOf(this.directory) + this.baseName + this.numberFormat.format(this.frameNumber) + ".jpg");
        boolean result = f.delete();
        if (!result) {
            System.out.println(Messages.getString("trouble_removing_last_frame"));
        }
        this.pictureList.remove(this.pictureList.size() - 1);
    }

    public void show() {
        if (!this.shown) {
            this.shown = true;
            if (this.pictureList.size() > 0) {
                int lastIndex = this.pictureList.size() - 1;
                Picture lastPicture = (Picture)this.pictureList.get(lastIndex);
                this.moviePlayer = new MoviePlayer(this.pictureList);
                this.moviePlayer.setVisible(true);
            } else {
                System.out.println(String.valueOf(Messages.getString("There_are_no_frames_to_show_yet___")) + Messages.getString("When_you_add_a_frame_it_will_be_shown"));
            }
        }
    }

    public void play(int framesPerSecond) {
        if (this.pictureList.size() > 0) {
            this.shown = true;
            if (this.moviePlayer == null) {
                this.moviePlayer = new MoviePlayer(this.pictureList);
            }
            this.moviePlayer.playMovie(framesPerSecond);
        }
    }

    public static void main(String[] args) {
        String dir = "c:/intro-prog-java/movies/rectangle/";
        FrameSequencer frameSequencer = new FrameSequencer(dir);
    }
}

