/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import movieMaker.FrameSequencer;
import movieMaker.Picture;
import movieMaker.VideoCapturer;

public class MovieCapturer
implements VideoCapturer {
    private FrameSequencer frameSequencer = null;
    private int framesPerSec = 16;
    private Rectangle region = null;

    public MovieCapturer(String directory) {
        this.frameSequencer = new FrameSequencer(directory);
    }

    public MovieCapturer(String directory, String baseName) {
        this.frameSequencer = new FrameSequencer(directory, baseName);
    }

    @Override
    public FrameSequencer getFrameSequencer() {
        return this.frameSequencer;
    }

    @Override
    public int getFramesPerSecond() {
        return this.framesPerSec;
    }

    @Override
    public void setFramesPerSecond(int frameRate) {
        this.framesPerSec = frameRate;
    }

    @Override
    public Rectangle getRegion() {
        return this.region;
    }

    @Override
    public BufferedImage captureScreen() throws Exception {
        BufferedImage image = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        return image;
    }

    public BufferedImage captureRegion(int x1, int y1, int width, int height) throws AWTException {
        BufferedImage screen = new Robot().createScreenCapture(new Rectangle(x1, y1, width, height));
        return screen;
    }

    public BufferedImage captureRegion() throws Exception {
        if (this.region != null) {
            BufferedImage image = new Robot().createScreenCapture(this.region);
            return image;
        }
        return this.captureScreen();
    }

    public void captureMovie() {
        boolean done = false;
        BufferedImage image = null;
        long startTime = 0L;
        long endTime = 0L;
        int timeToSleep = 1000 / this.framesPerSec;
        while (!done) {
            try {
                startTime = System.currentTimeMillis();
                image = this.captureRegion();
                this.frameSequencer.addFrame(new Picture(image));
                endTime = System.currentTimeMillis();
                Thread.sleep((long)timeToSleep - (endTime - startTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.captureMovie();
    }

    public void captureMovie(int numSeconds) {
        BufferedImage image = null;
        int timeToSleep = 1000 / this.framesPerSec;
        long startTime = 0L;
        long endTime = 0L;
        int i = 0;
        while (i < this.framesPerSec * numSeconds) {
            try {
                startTime = System.currentTimeMillis();
                image = this.captureRegion();
                this.frameSequencer.addFrame(new Picture(image));
                endTime = System.currentTimeMillis();
                Thread.sleep((long)timeToSleep - (endTime - startTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void captureMovie(int x1, int y1, int width, int height) {
        boolean done = false;
        long startTime = 0L;
        long endTime = 0L;
        BufferedImage image = null;
        int timeToSleep = 1000 / this.framesPerSec;
        while (!done) {
            try {
                startTime = System.currentTimeMillis();
                image = this.captureRegion(x1, y1, width, height);
                this.frameSequencer.addFrame(new Picture(image));
                endTime = System.currentTimeMillis();
                Thread.sleep((long)timeToSleep - (endTime - startTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void captureMovie(int x1, int y1, int width, int height, int numSeconds) {
        long startTime = 0L;
        long endTime = 0L;
        BufferedImage image = null;
        int timeToSleep = 1000 / this.framesPerSec;
        int i = 0;
        while (i < numSeconds * this.framesPerSec) {
            try {
                startTime = System.currentTimeMillis();
                image = this.captureRegion(x1, y1, width, height);
                this.frameSequencer.addFrame(new Picture(image));
                endTime = System.currentTimeMillis();
                Thread.sleep((long)timeToSleep - (endTime - startTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void playMovie() {
        this.frameSequencer.play(this.framesPerSec);
    }

    @Override
    public void setRegion(Rectangle theRegion) {
        if (theRegion.getWidth() % 4.0 != 0.0 || theRegion.getHeight() % 4.0 != 0.0) {
            int width = (int)theRegion.getWidth() / 4 * 4;
            int height = (int)theRegion.getHeight() / 4 * 4;
            this.region = new Rectangle((int)theRegion.getX(), (int)theRegion.getY(), width, height);
        } else {
            this.region = theRegion;
        }
    }

    @Override
    public void startCapture() {
        this.captureMovie();
    }

    @Override
    public void startCapture(int numSeconds) {
        this.captureMovie(numSeconds);
    }

    @Override
    public void stopCapture() {
    }
}

