/*
 * Decompiled with CFR 0.152.
 */
package movieMaker;

import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import movieMaker.AnimationPanel;
import movieMaker.ButtonPanel;
import movieMaker.FileChooser;
import movieMaker.MovieWriter;
import movieMaker.Picture;
import movieMaker.SimpleOutput;

public class MoviePlayer {
    private JFrame frame = new JFrame(Messages.getString("Movie_Player"));
    private JLabel frameLabel = new JLabel(Messages.getString("No_images_yet__"));
    private AnimationPanel animationPanel = null;
    private String dir = null;

    public MoviePlayer(List pictureList) {
        this.animationPanel = new AnimationPanel(pictureList);
        Picture p = (Picture)pictureList.get(0);
        String fileName = p.getFileName();
        File f = new File(fileName);
        this.dir = String.valueOf(f.getParent()) + "/";
        this.init();
    }

    public MoviePlayer(String directory) {
        this.animationPanel = new AnimationPanel(directory);
        this.dir = directory;
        this.init();
    }

    public MoviePlayer() {
        String directory;
        SimpleOutput.showInformation(String.valueOf(Messages.getString("Please_pick_a_")) + Messages.getString("directory_that_contains_the_JPEG_frames"));
        this.dir = directory = FileChooser.pickADirectory();
        this.animationPanel = new AnimationPanel(directory);
        this.init();
    }

    public void showNext() {
        this.animationPanel.showNext();
        this.frameLabel.setText(String.valueOf(Messages.getString("Frame_Number_")) + this.animationPanel.getCurrIndex());
        this.frame.repaint();
    }

    public void showPrevious() {
        this.animationPanel.showPrev();
        this.frameLabel.setText(String.valueOf(Messages.getString("Frame_Number_")) + this.animationPanel.getCurrIndex());
        this.frame.repaint();
    }

    public void playMovie() {
        this.frameLabel.setText(Messages.getString("Playing_Movie"));
        this.frame.repaint();
        this.animationPanel.showAll();
        this.frameLabel.setText(String.valueOf(Messages.getString("Frame_Number_")) + this.animationPanel.getCurrIndex());
        this.frame.repaint();
    }

    public void playMovie(int framesPerSecond) {
        this.animationPanel.setFramesPerSec(framesPerSecond);
        this.playMovie();
    }

    public void setFrameRate(int rate) {
        this.animationPanel.setFramesPerSec(rate);
    }

    public void delAllBefore() {
        this.animationPanel.removeAllBefore();
    }

    public void delAllAfter() {
        this.animationPanel.removeAllAfter();
    }

    public void writeQuicktime() {
        MovieWriter writer = new MovieWriter(this.animationPanel.getFramesPerSec(), this.dir);
        writer.writeQuicktime();
    }

    public void writeAVI() {
        MovieWriter writer = new MovieWriter(this.animationPanel.getFramesPerSec(), this.dir);
        writer.writeAVI();
    }

    public void addPicture(Picture picture) {
        this.animationPanel.add(picture);
        this.showNext();
    }

    private void init() {
        this.frame.setDefaultCloseOperation(3);
        Container container = this.frame.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        container.add((Component)this.animationPanel, "Center");
        JPanel labelPanel = new JPanel();
        labelPanel.add(this.frameLabel);
        container.add((Component)labelPanel, "North");
        container.add((Component)new ButtonPanel(this), "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void setVisible(boolean flag) {
        this.frame.setVisible(flag);
    }

    public static void main(String[] args) {
        MoviePlayer moviePlayer = new MoviePlayer();
        moviePlayer.playMovie(16);
    }
}

